**Тестовое задание QA** 

**E2E UI**

**Цель:**  
Создать автоматический e2e тест для проверки сценария покупки товара на сайте [saucedemo.com](https://www.saucedemo.com/) с использованием Python \+ Selenium или Playwright. Тест должен проверять процесс от авторизации до завершения покупки, с возможностью легко воспроизвести его на любом компьютере.

### **Требования:**

#### **1\. Сценарий теста:**

Тест должен выполнять следующие действия на сайте [saucedemo.com](https://www.saucedemo.com/):

* **Авторизация:** Использовать тестовый аккаунт:  
  * Логин: standard\_user  
  * Пароль: secret\_sauce  
* **Выбор товара:** Выбрать один товар (например, "Sauce Labs Backpack") и добавить его в корзину.  
* **Оформление покупки:**  
  * Перейти в корзину и убедиться, что товар добавлен.  
  * Оформить покупку, заполнив поля  
  * Завершить покупку.  
* **Проверка:** Убедиться, что покупка завершена успешно.

### **Ожидаемый результат:**

Кандидат должен предоставить готовый репозиторий с проектом, который можно развернуть и запустить по инструкции в **README.md**. Тест должен корректно авторизоваться на сайте, выбрать товар, оформить покупку и проверить успешное завершение покупки.

**GitHub API**

**Цель**  
Создать автоматический тест для проверки работы с GitHub API на языке Python. Тест должен уметь создавать, проверять наличие и удалять репозиторий на GitHub. Необходимо предоставить решение, которое легко воспроизводимо на любом компьютере.

**Требования**

1. **Использование GitHub API**:  
   * Скрипт должен использовать API GitHub для выполнения следующих операций:  
     1. Создание нового публичного репозитория.  
     2. Проверка списка репозиториев для подтверждения создания.  
     3. Удаление репозитория.  
2. **Использование переменных окружения**:  
   * Входные данные (имя пользователя GitHub, токен API и имя репозитория) должны передаваться через переменные окружения или файл конфигурации .env.  
3. **Зависимости**:  
   * Зависимости должны быть описаны в файле requirements.txt.  
   * Необходимые библиотеки (пример): requests и python-dotenv.  
4. **Инструкция по запуску**:  
   * Проект должен содержать файл README.md с подробной инструкцией, как установить зависимости, настроить переменные окружения и запустить тест.  
5. **Структура проекта**:  
   * Проект должен содержать следующие файлы:  
     1. test\_api.py — основной скрипт с тестом.  
     2. .env — файл с переменными окружения (необходимо указать пример).  
     3. requirements.txt — файл с зависимостями.  
     4. README.md — инструкция по установке и запуску.

**Ожидаемый результат**  
Кандидат должен предоставить готовый репозиторий с проектом, который можно развернуть и запустить по инструкции в README.md. Тест должен корректно создавать, проверять и удалять репозиторий на GitHub.